<?php
/**
 * Template for displaying single documents.
 *
 * Note: Replace all instances of `Barn2\Plugin\Document_Library_Pro` with the
 * correct namespace for your plugin variant:
 *   - Advanced:   Barn2\Plugin\Document_Library_Advanced\Dependencies\Document_Library_Core
 *   - Essentials: Barn2\Plugin\Document_Library_Essentials\Dependencies\Document_Library_Core
 *
 * @package <your-theme>
 */

use Barn2\Plugin\Document_Library_Pro\Util\Options;
use Barn2\Plugin\Document_Library_Pro\Frontend_Scripts;

get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

	<?php while ( have_posts() ) : the_post(); ?>

		<?php
		$document        = dlp_get_document( get_the_ID() );
		$display_options = Options::get_document_display_fields();
		$options         = Options::get_user_shortcode_options();

		if ( ! $document ) {
			continue;
		}

		?>
        <div class="dlp-document-title">
            <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
        </div>

        <div class="lp-document-main-wrapper">

		<div class="dlp-document-main">
			
			<?php the_content(); ?>
		</div>
       

		<?php if (
			$document->get_download_url() ||
			$document->get_file_type() ||
			$document->get_file_name() ||
			$document->get_file_size() ||
			$document->get_author_list() ||
			$document->get_category_list() ||
			$document->get_tag_list() ||
			has_post_thumbnail()
		) : ?>

			<div class="dlp-document-info">
				<?php if ( $document->get_download_url() ) : ?>
					<?php Frontend_Scripts::load_download_count_scripts(); ?>
					<div class="dlp-document-info-buttons">
						<?php echo $document->get_download_button_v2( $options['link_text'], $options['link_style'], $options['link_icon'], 'direct', $options['link_target'] ); ?>
						
						<?php if ( $document->is_allowed_preview_mime_type() && $options['preview'] ) : ?>
							<?php Frontend_Scripts::load_preview_scripts(); ?>
							<?php echo $document->get_preview_button_v2( $options['preview_text'], $options['preview_style'], $options['preview_icon'], 'single' ); ?>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				<div id="dlp-document-info-list">
					<?php do_action( 'document_library_pro_single_document_details_list_before' ); ?>

					<?php if ( in_array( 'filename', $display_options, true ) && $document->get_file_name() ) : ?>
						<div class="dlp-document-info-filename">
							<span class="dlp-document-info-title"><?php esc_html_e( 'Filename: ', 'document-library-pro' ); ?></span>
							<?php echo esc_html( $document->get_file_name() ); ?>
						</div>
					<?php endif; ?>

					<?php if ( in_array( 'file_type', $display_options, true ) && $document->get_file_type() ) : ?>
						<div class="dlp-document-file-type">
							<span class="dlp-document-info-title"><?php esc_html_e( 'File Type: ', 'document-library-pro' ); ?></span>
							<?php echo esc_html( $document->get_file_type() ); ?>
						</div>
					<?php endif; ?>

					<?php if ( in_array( 'file_size', $display_options, true ) && $document->get_file_size() ) : ?>
						<div class="dlp-document-info-file-size">
							<span class="dlp-document-info-title"><?php esc_html_e( 'File Size: ', 'document-library-pro' ); ?></span>
							<?php echo esc_html( $document->get_file_size() ); ?>
						</div>
					<?php endif; ?>

					<?php if ( in_array( 'doc_categories', $display_options, true ) && $document->get_category_list() ) : ?>
						<div class="dlp-document-info-categories">
							<span class="dlp-document-info-title"><?php esc_html_e( 'Categories: ', 'document-library-pro' ); ?></span>
							<?php echo $document->get_category_list( true ); ?>
						</div>
					<?php endif; ?>

					<?php if ( in_array( 'doc_tags', $display_options, true ) && $document->get_tag_list() ) : ?>
						<div class="dlp-document-info-tags">
							<span class="dlp-document-info-title"><?php esc_html_e( 'Tags: ', 'document-library-pro' ); ?></span>
							<?php echo $document->get_tag_list( true ); ?>
						</div>
					<?php endif; ?>

					<?php if ( in_array( 'doc_author', $display_options, true ) && $document->get_author_list() ) : ?>
						<div class="dlp-document-info-author">
							<span class="dlp-document-info-title"><?php esc_html_e( 'Author: ', 'document-library-pro' ); ?></span>
							<?php echo $document->get_author_list( true ); ?>
						</div>
					<?php endif; ?>

					<?php if ( in_array( 'custom-fields', $display_options, true ) && $custom_fields = $document->get_custom_fields_list() ) : ?>
						<?php foreach ( $custom_fields as $custom_field ) : ?>
							<div class="dlp-document-info-custom-fields">
								<span class="dlp-document-info-title"><?php echo esc_html( $custom_field['label'] ); ?>:</span>
								<?php echo esc_html( $custom_field['value'] ); ?>
							</div>
						<?php endforeach; ?>
					<?php endif; ?>

					<?php if ( in_array( 'download_count', $display_options, true ) && $document->get_download_count() ) : ?>
						<div class="dlp-document-info-downloads">
							<span class="dlp-document-info-title"><?php esc_html_e( 'Downloads: ', 'document-library-pro' ); ?></span>
							<?php echo esc_html( $document->get_download_count() ); ?>
						</div>
					<?php endif; ?>

					<?php do_action( 'document_library_pro_single_document_details_list_after' ); ?>
				</div>

				<?php if ( in_array( 'thumbnail', $display_options, true ) && has_post_thumbnail() ) : ?>
					<div class="dlp-document-info-image">
						<?php
						the_post_thumbnail( apply_filters( 'document_library_pro_image_single_size', 'medium' ) );
						?>
					</div>
				<?php endif; ?>
			</div>

		<?php endif; ?>

        </div>

	<?php endwhile; ?>

	</main><!-- #main -->
</div><!-- #primary -->

<?php get_footer(); ?>
